/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.StringUtils;
import cool.scx.util.ZipUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private final List<ZipItem> items = new ArrayList<ZipItem>();

    public ZipBuilder put(String path) {
        this.items.add(new ZipItem(path, null, null, ZipItemType.DIR));
        return this;
    }

    public ZipBuilder put(String path, File f) {
        this.items.add(new ZipItem(path, f, null, ZipItemType.FILE));
        return this;
    }

    public ZipBuilder put(String path, byte[] bytes) {
        this.items.add(new ZipItem(path, null, bytes, ZipItemType.BYTES));
        return this;
    }

    public ZipBuilder remove(String path) {
        if (StringUtils.notBlank(path)) {
            this.items.removeIf(c -> c.path.startsWith(path));
        }
        return this;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws Exception {
        for (ZipItem i : this.items) {
            switch (i.type()) {
                case DIR: {
                    zos.putNextEntry(new ZipEntry(i.path + "/"));
                    break;
                }
                case FILE: {
                    if (i.file.isDirectory()) {
                        ZipUtils.writeToZipOutputStream(i.file.toPath(), zos, i.path + "/");
                        break;
                    }
                    zos.putNextEntry(new ZipEntry(i.path));
                    Files.copy(i.file.toPath(), zos);
                    break;
                }
                case BYTES: {
                    zos.putNextEntry(new ZipEntry(i.path));
                    zos.write(i.bytes);
                }
            }
            zos.closeEntry();
        }
    }

    public byte[] toZipBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(bo);){
            this.writeToZipOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public void toZipFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.writeToZipOutputStream(zos);
        }
    }

    record ZipItem(String path, File file, byte[] bytes, ZipItemType type) {
    }

    static enum ZipItemType {
        DIR,
        FILE,
        BYTES;

    }
}

