/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

public final class HexUtils {
    private static final String HEX_CHAR_POOL_STR = "0123456789ABCDEF";
    private static final char[] HEX_CHAR_POOL = "0123456789ABCDEF".toCharArray();

    public static byte[] toBytes(String hex) {
        char[] charArray = hex.toCharArray();
        byte[] bytes = new byte[charArray.length / 2];
        for (int index = 0; index < bytes.length; ++index) {
            int highBit = HEX_CHAR_POOL_STR.indexOf(charArray[index * 2]);
            int lowBit = HEX_CHAR_POOL_STR.indexOf(charArray[index * 2 + 1]);
            bytes[index] = (byte)(highBit << 4 | lowBit);
        }
        return bytes;
    }

    public static String toHex(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int index = 0;
        for (byte b : bytes) {
            chars[index] = HEX_CHAR_POOL[b >>> 4 & 0xF];
            chars[index + 1] = HEX_CHAR_POOL[b & 0xF];
            index += 2;
        }
        return new String(chars);
    }
}

