/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.FileUtils;
import cool.scx.util.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    public static void zip(Path sourcePath, Path outputPath, ZipOption ... zipOptions) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        ZipOption.Info info = new ZipOption.Info(zipOptions);
        String rootPath = info.includeRoot() ? sourcePath.getFileName().toString() + "/" : "";
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            ZipUtils.writeToZipOutputStream(sourcePath, zos, rootPath);
        }
    }

    public static void writeToZipOutputStream(final Path sourcePath, final ZipOutputStream zos, final String rootPath) throws IOException {
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String zipEntryPath = sourcePath.relativize(dir).toString();
                if (StringUtils.notBlank(zipEntryPath) && attrs.isDirectory()) {
                    zos.putNextEntry(new ZipEntry(rootPath + zipEntryPath + "/"));
                    zos.closeEntry();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String zipEntryPath = sourcePath.relativize(file).toString();
                if (StringUtils.notBlank(zipEntryPath)) {
                    if (attrs.isDirectory()) {
                        zos.putNextEntry(new ZipEntry(rootPath + zipEntryPath + "/"));
                    } else {
                        zos.putNextEntry(new ZipEntry(rootPath + zipEntryPath));
                        Files.copy(file, zos);
                    }
                    zos.closeEntry();
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void unzip(Path zipFilePath, Path outputPath, ZipOption ... zipOptions) throws IOException {
        Files.createDirectories(outputPath, new FileAttribute[0]);
        ZipOption.Info info = new ZipOption.Info(zipOptions);
        String rootPath = info.includeRoot() ? FileUtils.getNameWithoutExtension(zipFilePath.getFileName().toString()) + "/" : "";
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path unzipFilePath = outputPath.resolve(rootPath + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(unzipFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(unzipFilePath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, unzipFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public static enum ZipOption {
        INCLUDE_ROOT;


        static class Info {
            boolean includeRoot;

            Info(ZipOption ... options) {
                for (ZipOption option : options) {
                    switch (option) {
                        case INCLUDE_ROOT: {
                            this.includeRoot = true;
                        }
                    }
                }
            }

            boolean includeRoot() {
                return this.includeRoot;
            }
        }
    }
}

