/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.functional.ScxHandlerR;
import cool.scx.util.StringUtils;
import cool.scx.util.URIBuilder;
import cool.scx.util.ZipUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private final List<ZipItem> items = new ArrayList<ZipItem>();

    public ZipBuilder put(String path) {
        this.items.add(new ZipItem(path));
        return this;
    }

    public ZipBuilder put(String path, File f) {
        this.items.add(new ZipItem(path, f));
        return this;
    }

    public ZipBuilder put(String path, byte[] bytes) {
        this.items.add(new ZipItem(path, bytes));
        return this;
    }

    public ZipBuilder put(String path, ScxHandlerR<byte[]> bytesSupplier) {
        this.items.add(new ZipItem(path, bytesSupplier));
        return this;
    }

    public ZipBuilder put(String path, InputStream inputStream) {
        this.items.add(new ZipItem(path, inputStream));
        return this;
    }

    public ZipBuilder remove(String path) {
        String p = URIBuilder.normalize(path);
        if (StringUtils.notBlank(path)) {
            this.items.removeIf(c -> c.path.startsWith(p));
        }
        return this;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws Exception {
        for (ZipItem i : this.items) {
            switch (i.type) {
                case DIR: {
                    zos.putNextEntry(new ZipEntry(i.path));
                    break;
                }
                case FILE: {
                    if (i.file.isDirectory()) {
                        ZipUtils.writeToZipOutputStream(i.file.toPath(), zos, i.path);
                        break;
                    }
                    zos.putNextEntry(new ZipEntry(i.path));
                    Files.copy(i.file.toPath(), zos);
                    break;
                }
                case BYTES: {
                    zos.putNextEntry(new ZipEntry(i.path));
                    zos.write(i.bytes);
                    break;
                }
                case BYTES_SUPPLIER: {
                    zos.putNextEntry(new ZipEntry(i.path));
                    zos.write(i.bytesSupplier.handle());
                    break;
                }
                case INPUT_STREAM: {
                    zos.putNextEntry(new ZipEntry(i.path));
                    i.inputStream.transferTo(zos);
                }
            }
            zos.closeEntry();
        }
    }

    public byte[] toZipBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(bo);){
            this.writeToZipOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public void toZipFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.writeToZipOutputStream(zos);
        }
    }

    static final class ZipItem {
        private final String path;
        private final ZipItemType type;
        private File file;
        private byte[] bytes;
        private ScxHandlerR<byte[]> bytesSupplier;
        private InputStream inputStream;

        ZipItem(String path, File file) {
            this.path = URIBuilder.trimSlash(URIBuilder.normalize(path));
            this.file = file;
            this.type = ZipItemType.FILE;
        }

        ZipItem(String path, byte[] bytes) {
            this.path = URIBuilder.trimSlash(URIBuilder.normalize(path));
            this.bytes = bytes;
            this.type = ZipItemType.BYTES;
        }

        ZipItem(String path, ScxHandlerR<byte[]> bytesSupplier) {
            this.path = URIBuilder.trimSlash(URIBuilder.normalize(path));
            this.bytesSupplier = bytesSupplier;
            this.type = ZipItemType.BYTES_SUPPLIER;
        }

        ZipItem(String path, InputStream inputStream) {
            this.path = URIBuilder.trimSlash(URIBuilder.normalize(path));
            this.inputStream = inputStream;
            this.type = ZipItemType.INPUT_STREAM;
        }

        ZipItem(String path) {
            this.path = URIBuilder.addSlashEnd(URIBuilder.trimSlash(URIBuilder.normalize(path)));
            this.type = ZipItemType.DIR;
        }
    }

    static enum ZipItemType {
        DIR,
        FILE,
        BYTES,
        BYTES_SUPPLIER,
        INPUT_STREAM;

    }
}

