/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.FileUtils;
import cool.scx.util.URIBuilder;
import cool.scx.util.zip.ZipDataSource;
import cool.scx.util.zip.ZipOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnZipBuilder
extends ZipDataSource {
    public UnZipBuilder(Path path) {
        super(path);
    }

    public UnZipBuilder(byte[] bytes) {
        super(bytes);
    }

    public UnZipBuilder(Supplier<byte[]> bytesSupplier) {
        super(bytesSupplier);
    }

    public UnZipBuilder(InputStream inputStream) {
        super(inputStream);
    }

    public void toFile(Path outputPath, ZipOptions zipOptions) throws IOException {
        Files.createDirectories(outputPath, new FileAttribute[0]);
        String rootPath = this.getRootPath(zipOptions);
        try (ZipInputStream zis = new ZipInputStream(this.toInputStream(), zipOptions.charset());){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                Path unzipFilePath = outputPath.resolve(rootPath + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(unzipFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(unzipFilePath.getParent(), new FileAttribute[0]);
                    Files.copy(zis, unzipFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public void toFile(Path outputPath) throws IOException {
        this.toFile(outputPath, new ZipOptions());
    }

    public String getRootPath(ZipOptions zipOptions) {
        String fileName = this.path.getFileName().toString();
        String fileNameWithoutExtension = FileUtils.getFileNameWithoutExtension(fileName);
        return this.type == ZipDataSource.Type.PATH && zipOptions.includeRoot() ? URIBuilder.addSlashEnd(fileNameWithoutExtension) : "";
    }
}

