/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.nio.charset.StandardCharsets;

public final class HexUtils {
    private static final byte[] HEX_CHAR_POOL = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] CHAR_BYTE_MAP = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public static byte[] toBytes(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int charsIndex = 0;
        for (int bytesIndex = 0; bytesIndex < bytes.length; ++bytesIndex) {
            byte highBit = CHAR_BYTE_MAP[chars[charsIndex]];
            byte lowBit = CHAR_BYTE_MAP[chars[charsIndex + 1]];
            bytes[bytesIndex] = (byte)(highBit << 4 | lowBit);
            charsIndex += 2;
        }
        return bytes;
    }

    public static String toHex(byte[] bytes) {
        byte[] chars = new byte[bytes.length * 2];
        int charsIndex = 0;
        for (int bytesIndex = 0; bytesIndex < bytes.length; ++bytesIndex) {
            byte b = bytes[bytesIndex];
            chars[charsIndex] = HEX_CHAR_POOL[b >>> 4 & 0xF];
            chars[charsIndex + 1] = HEX_CHAR_POOL[b & 0xF];
            charsIndex += 2;
        }
        return new String(chars, StandardCharsets.UTF_8);
    }
}

