/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.jasypt.util.binary.AES256BinaryEncryptor;
import org.jasypt.util.binary.BinaryEncryptor;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.PasswordEncryptor;
import org.jasypt.util.text.AES256TextEncryptor;
import org.jasypt.util.text.TextEncryptor;

public final class CryptoUtils {
    private static final PasswordEncryptor defaultPasswordEncryptor = new BasicPasswordEncryptor();

    private static TextEncryptor getTextEncryptor(String encryptorPassword) {
        AES256TextEncryptor encryptor = new AES256TextEncryptor();
        encryptor.setPassword(encryptorPassword);
        return encryptor;
    }

    private static BinaryEncryptor getBinaryEncryptor(String encryptorPassword) {
        AES256BinaryEncryptor encryptor = new AES256BinaryEncryptor();
        encryptor.setPassword(encryptorPassword);
        return encryptor;
    }

    public static String encryptText(String text, String encryptorPassword) {
        return CryptoUtils.getTextEncryptor(encryptorPassword).encrypt(text);
    }

    public static String decryptText(String text, String encryptorPassword) {
        return CryptoUtils.getTextEncryptor(encryptorPassword).decrypt(text);
    }

    public static byte[] encryptBinary(byte[] binary, String encryptorPassword) {
        return CryptoUtils.getBinaryEncryptor(encryptorPassword).encrypt(binary);
    }

    public static byte[] decryptBinary(byte[] encryptedBinary, String encryptorPassword) {
        return CryptoUtils.getBinaryEncryptor(encryptorPassword).decrypt(encryptedBinary);
    }

    public static String encryptPassword(String password) {
        return defaultPasswordEncryptor.encryptPassword(password);
    }

    public static boolean checkPassword(String plainPassword, String encryptedPassword) {
        return defaultPasswordEncryptor.checkPassword(plainPassword, encryptedPassword);
    }

    public static byte[] encrypt(String algorithm, byte[] password, byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = new SecretKeySpec(password, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(String algorithm, byte[] password, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = new SecretKeySpec(password, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    public static byte[] encrypt(String algorithm, AlgorithmParameters params, byte[] password, byte[] data) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec key = new SecretKeySpec(password, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)key, params);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(String algorithm, AlgorithmParameters params, byte[] password, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec key = new SecretKeySpec(password, algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)key, params);
        return cipher.doFinal(data);
    }
}

