/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.RandomUtils;
import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.impl.MimeMapping;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class FormData {
    private static final UnpooledByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false);
    private final List<FormDataItem> items = new ArrayList<FormDataItem>();

    private static HttpPostRequestEncoder initEncoder(FormData formData, HttpRequest request) throws HttpPostRequestEncoder.ErrorDataEncoderException, IOException {
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)new DefaultHttpDataFactory(), request, true, StandardCharsets.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        for (FormDataItem formDataPart : formData.items) {
            switch (formDataPart.type) {
                case ATTRIBUTE: {
                    encoder.addBodyAttribute(formDataPart.name, formDataPart.attributeValue);
                    break;
                }
                case FILE_UPLOAD_PATH: {
                    encoder.addBodyFileUpload(formDataPart.name, formDataPart.filename, formDataPart.fileUploadPath.toFile(), formDataPart.contentType, false);
                    break;
                }
                case FILE_UPLOAD_BYTES: {
                    MemoryFileUpload fileUpload = new MemoryFileUpload(formDataPart.name, formDataPart.filename, formDataPart.contentType, null, null, (long)formDataPart.fileUploadPathBytes.length);
                    fileUpload.setContent(Unpooled.buffer().writeBytes(formDataPart.fileUploadPathBytes));
                    encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
                }
            }
        }
        encoder.finalizeRequest();
        return encoder;
    }

    private static void write0(HttpClientRequest clientRequest, HttpPostRequestEncoder encoder) throws Exception {
        if (!encoder.isEndOfInput()) {
            HttpContent chunk = encoder.readChunk((ByteBufAllocator)ALLOC);
            ByteBuf content = chunk.content();
            Buffer buff = Buffer.buffer((ByteBuf)content);
            clientRequest.write((Object)buff).onSuccess(c -> ScxExceptionHelper.wrap(() -> FormData.write0(clientRequest, encoder)));
        } else {
            clientRequest.end();
        }
    }

    public FormData attribute(String name, Object text) {
        this.items.add(new FormDataItem(name, text.toString()));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte) {
        this.items.add(new FormDataItem(name, fileByte));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte, String filename) {
        this.items.add(new FormDataItem(name, fileByte, filename));
        return this;
    }

    public FormData fileUpload(String name, byte[] fileByte, String filename, String contentType) {
        this.items.add(new FormDataItem(name, fileByte, filename, contentType));
        return this;
    }

    public FormData fileUpload(String name, Path filePath) {
        this.items.add(new FormDataItem(name, filePath));
        return this;
    }

    public FormData fileUpload(String name, Path filePath, String filename) {
        this.items.add(new FormDataItem(name, filePath, filename));
        return this;
    }

    public FormData fileUpload(String name, Path filePath, String filename, String contentType) {
        this.items.add(new FormDataItem(name, filePath, filename, contentType));
        return this;
    }

    public FormData remove(String name) {
        this.items.removeIf(formDataItem -> name.equals(formDataItem.name));
        return this;
    }

    public void write(HttpClientRequest request) {
        ScxExceptionHelper.wrap(() -> {
            request.setChunked(true);
            DefaultFullHttpRequest tempRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
            HttpPostRequestEncoder encoder = FormData.initEncoder(this, (HttpRequest)tempRequest);
            tempRequest.headers().forEach(k -> request.putHeader((String)k.getKey(), (String)k.getValue()));
            FormData.write0(request, encoder);
        });
    }

    static final class FormDataItem {
        private final FormDataItemType type;
        private final String name;
        private final String filename;
        private final String contentType;
        private String attributeValue;
        private Path fileUploadPath;
        private byte[] fileUploadPathBytes;

        FormDataItem(String name, String value) {
            this.type = FormDataItemType.ATTRIBUTE;
            this.name = Objects.requireNonNull(name);
            this.attributeValue = value;
            this.filename = null;
            this.contentType = null;
        }

        FormDataItem(String name, byte[] content) {
            this(name, content, RandomUtils.randomUUID());
        }

        FormDataItem(String name, byte[] content, String filename) {
            this(name, content, filename, MimeMapping.getMimeTypeForFilename((String)filename));
        }

        FormDataItem(String name, byte[] content, String filename, String contentType) {
            this.type = FormDataItemType.FILE_UPLOAD_BYTES;
            this.name = Objects.requireNonNull(name);
            this.fileUploadPathBytes = content;
            this.filename = StringUtils.notBlank(filename) ? filename : RandomUtils.randomUUID();
            this.contentType = StringUtils.notBlank(contentType) ? contentType : MimeMapping.getMimeTypeForExtension((String)"bin");
        }

        FormDataItem(String name, Path filePath) {
            this(name, filePath, filePath.getFileName().toString());
        }

        FormDataItem(String name, Path filePath, String filename) {
            this(name, filePath, filename, MimeMapping.getMimeTypeForFilename((String)filename));
        }

        FormDataItem(String name, Path filePath, String filename, String contentType) {
            this.type = FormDataItemType.FILE_UPLOAD_PATH;
            this.name = Objects.requireNonNull(name);
            this.fileUploadPath = filePath;
            this.filename = StringUtils.notBlank(filename) ? filename : RandomUtils.randomUUID();
            this.contentType = StringUtils.notBlank(contentType) ? contentType : MimeMapping.getMimeTypeForExtension((String)"bin");
        }
    }

    static enum FormDataItemType {
        ATTRIBUTE,
        FILE_UPLOAD_PATH,
        FILE_UPLOAD_BYTES;

    }
}

