/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.zip.ZipDataSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;

public class GzipBuilder
extends ZipDataSource {
    public GzipBuilder(Path path) {
        super(path);
    }

    public GzipBuilder(byte[] bytes) {
        super(bytes);
    }

    public GzipBuilder(Supplier<byte[]> bytesSupplier) {
        super(bytesSupplier);
    }

    public GzipBuilder(InputStream inputStream) {
        super(inputStream);
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(bo);){
            this.writeToOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public void toFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (GZIPOutputStream zos = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.writeToOutputStream(zos);
        }
    }
}

