/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http_client;

import cool.scx.enumeration.HttpMethod;
import cool.scx.http_client.ScxHttpClientRequestBody;
import cool.scx.http_client.body.EmptyBody;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;

public class ScxHttpClientRequest {
    private final HttpRequest.Builder builder;
    private ScxHttpClientRequestBody body = new EmptyBody();
    private String method;

    public ScxHttpClientRequest() {
        this.builder = HttpRequest.newBuilder();
    }

    public ScxHttpClientRequest body(ScxHttpClientRequestBody body) {
        this.body = body;
        return this;
    }

    public ScxHttpClientRequest method(HttpMethod method) {
        this.method = method.name();
        return this;
    }

    public ScxHttpClientRequest method(String method) {
        this.method = method;
        return this;
    }

    public ScxHttpClientRequest timeout(Duration duration) {
        this.builder.timeout(duration);
        return this;
    }

    public ScxHttpClientRequest uri(URI uri) {
        this.builder.uri(uri);
        return this;
    }

    public ScxHttpClientRequest setHeader(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public ScxHttpClientRequest addHeader(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public HttpRequest createHttpRequest() {
        return this.builder.method(this.method, this.body.bodyPublisher(this.builder)).build();
    }
}

