/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.StringUtils;
import cool.scx.util.URIBuilder;
import cool.scx.util.zip.ZipBuilderItem;
import cool.scx.util.zip.ZipOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private final List<ZipBuilderItem> items = new ArrayList<ZipBuilderItem>();

    public ZipBuilder() {
    }

    public ZipBuilder(Path path, ZipOption ... zipOptions) {
        this.put(path, zipOptions);
    }

    public ZipBuilder put(String zipPath) {
        this.items.add(new ZipBuilderItem(zipPath));
        return this;
    }

    public ZipBuilder put(Path path, ZipOption ... zipOptions) {
        this.items.add(new ZipBuilderItem("", path, zipOptions));
        return this;
    }

    public ZipBuilder put(String zipPath, Path path, ZipOption ... zipOptions) {
        this.items.add(new ZipBuilderItem(zipPath, path, zipOptions));
        return this;
    }

    public ZipBuilder put(String zipPath, byte[] bytes) {
        this.items.add(new ZipBuilderItem(zipPath, bytes));
        return this;
    }

    public ZipBuilder put(String zipPath, Supplier<byte[]> bytesSupplier) {
        this.items.add(new ZipBuilderItem(zipPath, bytesSupplier));
        return this;
    }

    public ZipBuilder put(String zipPath, InputStream inputStream) {
        this.items.add(new ZipBuilderItem(zipPath, inputStream));
        return this;
    }

    public ZipBuilder remove(String path) {
        String p = URIBuilder.normalize(path);
        if (StringUtils.notBlank(path)) {
            this.items.removeIf(c -> c.path.startsWith(p));
        }
        return this;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        for (ZipBuilderItem i : this.items) {
            i.writeToZipOutputStream(zos);
        }
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(bo);){
            this.writeToZipOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public void toFile(Path outputPath) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.writeToZipOutputStream(zos);
        }
    }
}

