/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.zip.ZipDataSource;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;

public class GunzipBuilder
extends ZipDataSource {
    public GunzipBuilder(Path path) {
        super(path);
    }

    public GunzipBuilder(byte[] bytes) {
        super(bytes);
    }

    public GunzipBuilder(Supplier<byte[]> bytesSupplier) {
        super(bytesSupplier);
    }

    public GunzipBuilder(InputStream inputStream) {
        super(inputStream);
    }

    public byte[] toBytes() throws Exception {
        try (GZIPInputStream zos = new GZIPInputStream(this.toInputStream());){
            byte[] byArray = zos.readAllBytes();
            return byArray;
        }
    }

    public void toFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (GZIPInputStream zos = new GZIPInputStream(this.toInputStream());){
            zos.transferTo(Files.newOutputStream(outputPath, new OpenOption[0]));
        }
    }
}

