/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.StringUtils;
import cool.scx.util.URIBuilder;
import cool.scx.util.zip.ZipDataSource;
import cool.scx.util.zip.ZipOption;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class ZipBuilderItem
extends ZipDataSource {
    final String zipPath;

    ZipBuilderItem(String zipPath, Path path, ZipOption ... zipOptions) {
        super(path);
        this.zipPath = ZipBuilderItem.getZipPathByPath(zipPath, path, zipOptions);
    }

    ZipBuilderItem(String zipPath, byte[] bytes) {
        super(bytes);
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
    }

    ZipBuilderItem(String zipPath, Supplier<byte[]> bytesSupplier) {
        super(bytesSupplier);
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
    }

    ZipBuilderItem(String zipPath, InputStream inputStream) {
        super(inputStream);
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
    }

    ZipBuilderItem(String zipPath) {
        this.zipPath = URIBuilder.addSlashEnd(URIBuilder.trimSlash(URIBuilder.normalize(zipPath)));
    }

    public static String getZipPathByPath(String zipPath, Path path, ZipOption ... zipOptions) {
        ZipOption.Info info = new ZipOption.Info(zipOptions);
        String fileName = path.getFileName().toString();
        String normalizeZipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
        if (Files.isDirectory(path, new LinkOption[0])) {
            String dirName = info.includeRoot() ? fileName : "";
            String rootPath = URIBuilder.join(normalizeZipPath, dirName);
            return StringUtils.isEmpty(rootPath) ? rootPath : URIBuilder.addSlashEnd(rootPath);
        }
        if (StringUtils.isEmpty(normalizeZipPath)) {
            return fileName;
        }
        if (info.useOriginalFileName()) {
            return URIBuilder.join(normalizeZipPath, fileName);
        }
        return normalizeZipPath;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        if (this.type == ZipDataSource.Type.PATH && Files.isDirectory(this.path, new LinkOption[0])) {
            this.writeToZipOutputStreamByDirectory(zos);
        } else {
            zos.putNextEntry(new ZipEntry(this.zipPath));
            this.writeToOutputStream(zos);
            zos.closeEntry();
        }
    }

    public void writeToZipOutputStreamByDirectory(final ZipOutputStream zos) throws IOException {
        Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String finalPath = ZipBuilderItem.this.zipPath + ZipBuilderItem.this.path.relativize(file);
                if (attrs.isDirectory()) {
                    zos.putNextEntry(new ZipEntry(finalPath + "/"));
                } else {
                    zos.putNextEntry(new ZipEntry(finalPath));
                    Files.copy(file, zos);
                }
                zos.closeEntry();
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

