/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private static final char[] NUMBER_POOL = "0123456789".toCharArray();
    private static final char[] NUMBER_AND_LETTER_POOL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String randomString(int size, boolean withLetter) {
        StringBuilder code = new StringBuilder();
        char[] pool = withLetter ? NUMBER_AND_LETTER_POOL : NUMBER_POOL;
        for (int i = 0; i < size; ++i) {
            code.append(pool[ThreadLocalRandom.current().nextInt(pool.length)]);
        }
        return code.toString();
    }

    public static String randomString(int size) {
        return RandomUtils.randomString(size, true);
    }

    public static int randomNumber(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }
}

