/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class URIBuilder {
    private static final Pattern pathSeparator = Pattern.compile("[/\\\\]+");
    private final String path;
    private final MultiMap<String, String> queryParams = new MultiMap();

    private URIBuilder(QueryStringDecoder decoder) {
        this.path = decoder.path();
        decoder.parameters().forEach(this.queryParams::putAll);
    }

    public static URIBuilder of(String str) {
        return new URIBuilder(new QueryStringDecoder(str, StandardCharsets.UTF_8));
    }

    public static URIBuilder of(URI uri) {
        return new URIBuilder(new QueryStringDecoder(uri, StandardCharsets.UTF_8));
    }

    public static String join(String ... uris) {
        return URIBuilder.normalize(String.join((CharSequence)"/", (CharSequence[])Arrays.stream(uris).filter(StringUtils::notBlank).toArray(String[]::new)));
    }

    public static String join(Collection<String> uris) {
        return URIBuilder.normalize(String.join((CharSequence)"/", (CharSequence[])uris.stream().filter(StringUtils::notBlank).toArray(String[]::new)));
    }

    public static String trimSlash(String uri) {
        char[] value = uri.toCharArray();
        int length = value.length;
        int st = URIBuilder.findSlashStart(value);
        int len = URIBuilder.findSlashEnd(value);
        return st > 0 || len < length ? new String(Arrays.copyOfRange(value, st, len)) : uri;
    }

    public static String trimSlashStart(String uri) {
        char[] value = uri.toCharArray();
        int st = URIBuilder.findSlashStart(value);
        return st > 0 ? new String(Arrays.copyOfRange(value, st, value.length)) : uri;
    }

    public static String trimSlashEnd(String uri) {
        char[] value = uri.toCharArray();
        int len = URIBuilder.findSlashEnd(value);
        return len < value.length ? new String(Arrays.copyOfRange(value, 0, len)) : uri;
    }

    private static int findSlashStart(char[] value) {
        int st;
        int length = value.length;
        for (st = 0; st < length && (value[st] == '/' || value[st] == '\\'); ++st) {
        }
        return st;
    }

    private static int findSlashEnd(char[] value) {
        int len;
        int st = 0;
        for (len = value.length; st < len && (value[len - 1] == '/' || value[len - 1] == '\\'); --len) {
        }
        return len;
    }

    public static String addSlashStart(String uri) {
        return "/" + URIBuilder.trimSlashStart(uri);
    }

    public static String addSlashEnd(String uri) {
        return URIBuilder.trimSlashEnd(uri) + "/";
    }

    public static String normalize(String uri) {
        char[] chars = uri.toCharArray();
        int index = 0;
        boolean isSeparator = false;
        for (char c : chars) {
            if (c == '/' || c == '\\') {
                if (!isSeparator) {
                    chars[index] = 47;
                    ++index;
                }
                isSeparator = true;
                continue;
            }
            chars[index] = c;
            ++index;
            isSeparator = false;
        }
        return new String(chars, 0, index);
    }

    public static String[] split(String uri) {
        return pathSeparator.split(uri, -1);
    }

    public URIBuilder addParam(String key, Object value) {
        this.queryParams.put(key, value.toString());
        return this;
    }

    public URIBuilder removeParam(String key) {
        this.queryParams.removeAll(key);
        return this;
    }

    public List<String> getParams(String key) {
        return this.queryParams.get(key);
    }

    public Map<String, List<String>> getAllParams() {
        return this.queryParams.toMultiValueMap();
    }

    public URIBuilder removeAllParams() {
        this.queryParams.clear();
        return this;
    }

    public URI build() {
        return URI.create(this.toString());
    }

    public String toString() {
        QueryStringEncoder encoder = new QueryStringEncoder(this.path, StandardCharsets.UTF_8);
        this.queryParams.forEach((arg_0, arg_1) -> ((QueryStringEncoder)encoder).addParam(arg_0, arg_1));
        return encoder.toString();
    }
}

