/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;

abstract class ZipDataSource {
    protected final Type type;
    protected Path path;
    protected byte[] bytes;
    protected Supplier<byte[]> bytesSupplier;
    protected InputStream inputStream;

    protected ZipDataSource(Path path) {
        this.path = path;
        this.type = Type.PATH;
    }

    protected ZipDataSource(byte[] bytes) {
        this.bytes = bytes;
        this.type = Type.BYTES;
    }

    protected ZipDataSource(Supplier<byte[]> bytesSupplier) {
        this.bytesSupplier = bytesSupplier;
        this.type = Type.BYTES_SUPPLIER;
    }

    protected ZipDataSource(InputStream inputStream) {
        this.inputStream = inputStream;
        this.type = Type.INPUT_STREAM;
    }

    protected ZipDataSource() {
        this.type = Type.NULL;
    }

    public void writeToOutputStream(OutputStream out) throws IOException {
        switch (this.type) {
            case NULL: {
                break;
            }
            case PATH: {
                Files.copy(this.path, out);
                break;
            }
            case BYTES: {
                out.write(this.bytes);
                break;
            }
            case BYTES_SUPPLIER: {
                out.write(this.bytesSupplier.get());
                break;
            }
            case INPUT_STREAM: {
                this.inputStream.transferTo(out);
            }
        }
    }

    public InputStream toInputStream() throws IOException {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NULL -> InputStream.nullInputStream();
            case Type.PATH -> Files.newInputStream(this.path, new OpenOption[0]);
            case Type.BYTES -> new ByteArrayInputStream(this.bytes);
            case Type.BYTES_SUPPLIER -> new ByteArrayInputStream(this.bytesSupplier.get());
            case Type.INPUT_STREAM -> this.inputStream;
        };
    }

    public static enum Type {
        NULL,
        PATH,
        BYTES,
        BYTES_SUPPLIER,
        INPUT_STREAM;

    }
}

