/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.zip.zip_data_source.ZipDataSource;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;

public final class GunzipBuilder {
    private final ZipDataSource zipDataSource;

    public GunzipBuilder(ZipDataSource zipDataSource) {
        this.zipDataSource = zipDataSource;
    }

    public GunzipBuilder(Path path) {
        this(ZipDataSource.of(path));
    }

    public GunzipBuilder(byte[] bytes) {
        this(ZipDataSource.of(bytes));
    }

    public GunzipBuilder(Supplier<byte[]> bytesSupplier) {
        this(ZipDataSource.of(bytesSupplier));
    }

    public GunzipBuilder(InputStream inputStream) {
        this(ZipDataSource.of(inputStream));
    }

    public byte[] toBytes() throws Exception {
        try (GZIPInputStream zos = new GZIPInputStream(this.zipDataSource.toInputStream());){
            byte[] byArray = zos.readAllBytes();
            return byArray;
        }
    }

    public void toFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (GZIPInputStream zos = new GZIPInputStream(this.zipDataSource.toInputStream());){
            zos.transferTo(Files.newOutputStream(outputPath, new OpenOption[0]));
        }
    }
}

