/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.zip.zip_data_source.ZipDataSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;

public final class GzipBuilder {
    private final ZipDataSource zipDataSource;

    public GzipBuilder(ZipDataSource zipDataSource) {
        this.zipDataSource = zipDataSource;
    }

    public GzipBuilder(Path path) {
        this(ZipDataSource.of(path));
    }

    public GzipBuilder(byte[] bytes) {
        this(ZipDataSource.of(bytes));
    }

    public GzipBuilder(Supplier<byte[]> bytesSupplier) {
        this(ZipDataSource.of(bytesSupplier));
    }

    public GzipBuilder(InputStream inputStream) {
        this(ZipDataSource.of(inputStream));
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(bo);){
            this.zipDataSource.writeToOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public void toFile(Path outputPath) throws Exception {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (GZIPOutputStream zos = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            this.zipDataSource.writeToOutputStream(zos);
        }
    }
}

