/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip.zip_data_source;

import cool.scx.util.zip.zip_data_source.BytesSupplierZipDataSource;
import cool.scx.util.zip.zip_data_source.BytesZipDataSource;
import cool.scx.util.zip.zip_data_source.InputStreamZipDataSource;
import cool.scx.util.zip.zip_data_source.NullZipDataSource;
import cool.scx.util.zip.zip_data_source.PathZipDataSource;
import cool.scx.util.zip.zip_data_source.ZipEntryDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public interface ZipDataSource {
    public static ZipDataSource of() {
        return new NullZipDataSource();
    }

    public static ZipDataSource of(Path path) {
        return new PathZipDataSource(path);
    }

    public static ZipDataSource of(byte[] bytes) {
        return new BytesZipDataSource(bytes);
    }

    public static ZipDataSource of(Supplier<byte[]> bytesSupplier) {
        return new BytesSupplierZipDataSource(bytesSupplier);
    }

    public static ZipDataSource of(InputStream inputStream) {
        return new InputStreamZipDataSource(inputStream);
    }

    public static ZipDataSource of(ZipEntry zipEntry, ZipFile zipFile) {
        return new ZipEntryDataSource(zipEntry, zipFile);
    }

    public void writeToOutputStream(OutputStream var1) throws IOException;

    public InputStream toInputStream() throws IOException;
}

