/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.zip;

import cool.scx.util.URIBuilder;
import cool.scx.util.zip.zip_data_source.ZipDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipBuilderItem {
    protected final String zipPath;
    protected final ZipDataSource zipDataSource;

    protected ZipBuilderItem(String zipPath, ZipDataSource zipDataSource) {
        this.zipPath = zipPath;
        this.zipDataSource = zipDataSource;
    }

    ZipBuilderItem(String zipPath, byte[] bytes) {
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
        this.zipDataSource = ZipDataSource.of(bytes);
    }

    ZipBuilderItem(String zipPath, Supplier<byte[]> bytesSupplier) {
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
        this.zipDataSource = ZipDataSource.of(bytesSupplier);
    }

    ZipBuilderItem(String zipPath, InputStream inputStream) {
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipPath));
        this.zipDataSource = ZipDataSource.of(inputStream);
    }

    ZipBuilderItem(String zipPath) {
        this.zipPath = URIBuilder.addSlashEnd(URIBuilder.trimSlash(URIBuilder.normalize(zipPath)));
        this.zipDataSource = ZipDataSource.of();
    }

    ZipBuilderItem(ZipEntry zipEntry, ZipFile zipFile) {
        this.zipPath = URIBuilder.trimSlash(URIBuilder.normalize(zipEntry.getName()));
        this.zipDataSource = ZipDataSource.of(zipEntry, zipFile);
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(this.zipPath));
        this.zipDataSource.writeToOutputStream(zos);
        zos.closeEntry();
    }

    public ZipDataSource zipDataSource() {
        return this.zipDataSource;
    }
}

