/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.CRC32;

public final class CRCUtils {
    public static String crc32(String data) {
        return CRCUtils.crc32(data != null ? data.getBytes(StandardCharsets.UTF_8) : null);
    }

    public static String crc32(byte[] data) {
        Objects.requireNonNull(data, "Data must not be empty !!!");
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return Long.toHexString(crc32.getValue());
    }

    public static String crc32(File data) throws IOException {
        Objects.requireNonNull(data, "Data must not be empty !!!");
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[262144];
        try (RandomAccessFile file = new RandomAccessFile(data, "r");){
            int read;
            while ((read = file.read(buffer, 0, 262144)) != -1) {
                crc32.update(buffer, 0, read);
            }
        }
        return Long.toHexString(crc32.getValue());
    }
}

