/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.HexUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class HashUtils {
    static final int CACHE_LENGTH = 262144;

    private static String digest(String data, String digestType) {
        return HashUtils.digest(data != null ? data.getBytes(StandardCharsets.UTF_8) : null, digestType);
    }

    private static String digest(byte[] data, String digestType) {
        Objects.requireNonNull(data, "Data must not be empty !!!");
        return HexUtils.toHex(HashUtils.getDigest(digestType).digest(data));
    }

    private static String digest(File data, String digestType) throws IOException {
        Objects.requireNonNull(data, "Data must not be empty !!!");
        MessageDigest digest = HashUtils.getDigest(digestType);
        byte[] buffer = new byte[262144];
        try (RandomAccessFile file = new RandomAccessFile(data, "r");){
            int read;
            while ((read = file.read(buffer, 0, 262144)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        return HexUtils.toHex(digest.digest());
    }

    public static String sha1(String data) {
        return HashUtils.digest(data, "SHA-1");
    }

    public static String sha1(byte[] data) {
        return HashUtils.digest(data, "SHA-1");
    }

    public static String sha1(File data) throws IOException {
        return HashUtils.digest(data, "SHA-1");
    }

    public static String sha256(String data) {
        return HashUtils.digest(data, "SHA-256");
    }

    public static String sha256(byte[] data) {
        return HashUtils.digest(data, "SHA-256");
    }

    public static String sha256(File data) throws IOException {
        return HashUtils.digest(data, "SHA-256");
    }

    public static String sha384(String data) {
        return HashUtils.digest(data, "SHA-384");
    }

    public static String sha384(byte[] data) {
        return HashUtils.digest(data, "SHA-384");
    }

    public static String sha384(File data) throws IOException {
        return HashUtils.digest(data, "SHA-384");
    }

    public static String sha512(String data) {
        return HashUtils.digest(data, "SHA-512");
    }

    public static String sha512(byte[] data) {
        return HashUtils.digest(data, "SHA-512");
    }

    public static String sha512(File data) throws IOException {
        return HashUtils.digest(data, "SHA-512");
    }

    public static String md5(String data) {
        return HashUtils.digest(data, "MD5");
    }

    public static String md5(byte[] data) {
        return HashUtils.digest(data, "MD5");
    }

    public static String md5(File data) throws IOException {
        return HashUtils.digest(data, "MD5");
    }

    private static MessageDigest getDigest(String digestType) {
        try {
            return MessageDigest.getInstance(digestType);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

