/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.io_stream_source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public interface OutputStreamSource {
    default public void toFile(Path outputPath, OpenOption ... options) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (OutputStream fo = Files.newOutputStream(outputPath, options);){
            this.writeToOutputStream(fo);
        }
    }

    default public byte[] toBytes() throws IOException {
        try (ByteArrayOutputStream bo = new ByteArrayOutputStream();){
            this.writeToOutputStream(bo);
            byte[] byArray = bo.toByteArray();
            return byArray;
        }
    }

    public void writeToOutputStream(OutputStream var1) throws IOException;
}

