/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.io_stream_source;

import cool.scx.util.io_stream_source.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PathSource
implements InputStreamSource {
    private final Path path;

    public PathSource(Path path) {
        this.path = path;
    }

    @Override
    public InputStream toInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public void writeToOutputStream(OutputStream out) throws IOException {
        Files.copy(this.path, out);
    }

    @Override
    public void toFile(Path outputPath, OpenOption ... options) throws IOException {
        Files.copy(this.path, outputPath, new CopyOption[0]);
    }

    @Override
    public byte[] toBytes() throws IOException {
        return Files.readAllBytes(this.path);
    }
}

