/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.multi_map;

import cool.scx.util.multi_map.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

abstract class AbstractMultiMap<K, V, C extends Collection<V>>
implements MultiMap<K, V> {
    private final Map<K, C> map;
    private int size = 0;

    public AbstractMultiMap(Supplier<Map<K, C>> mapSupplier) {
        this.map = mapSupplier.get();
    }

    public AbstractMultiMap() {
        this(LinkedHashMap::new);
    }

    @Override
    public Map<K, C> toMultiValueMap() {
        return this.map;
    }

    @Override
    public HashMap<K, V> toSingleValueMap() {
        HashMap tempMap = new HashMap();
        for (Map.Entry<K, C> e : this.map.entrySet()) {
            tempMap.put(e.getKey(), ((Collection)e.getValue()).iterator().next());
        }
        return tempMap;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public List<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public C get(K key) {
        return (C)this.map.computeIfAbsent(key, k -> this.createCollection());
    }

    @Override
    public boolean remove(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection != null && collection.remove(value)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(K key) {
        Collection collection = (Collection)this.map.remove(key);
        if (collection == null) {
            return Collections.emptyList();
        }
        C output = this.createCollection();
        output.addAll(collection);
        this.size -= collection.size();
        collection.clear();
        return Collections.unmodifiableCollection(output);
    }

    @Override
    public boolean put(K key, V value) {
        C collection = this.get(key);
        boolean add = collection.add(value);
        if (add) {
            ++this.size;
        }
        return add;
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> values) {
        C collection = this.get(key);
        boolean add = collection.addAll(values);
        if (add) {
            this.size += values.size();
        }
        return add;
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.map.values().stream().anyMatch(collection -> collection.contains(value));
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        for (Collection collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((key, valueCollection) -> valueCollection.forEach((? super T value) -> action.accept((Object)key, (Object)value)));
    }

    abstract C createCollection();
}

