/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.functional.ScxRunnable;
import cool.scx.util.MultiMap;
import cool.scx.util.ScxExceptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class $ {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static CompletableFuture<Void> async(ScxRunnable<?> runnable) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Thread.ofVirtual().start(() -> {
            try {
                runnable.run();
                promise.complete(null);
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    public static <T> CompletableFuture<T> async(Callable<T> callable) {
        CompletableFuture promise = new CompletableFuture();
        Thread.ofVirtual().start(() -> {
            try {
                Object t = callable.call();
                promise.complete(t);
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    public static <T> T await(CompletableFuture<T> promise) throws Throwable {
        try {
            return promise.get();
        }
        catch (Exception e) {
            throw ScxExceptionHelper.getRootCause(e);
        }
    }

    public static <K, T> MultiMap<K, T> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn) {
        return $.groupingBy(list, keyFn, t -> t);
    }

    public static <K, V, T> MultiMap<K, V> groupingBy(Iterable<T> list, Function<? super T, ? extends K> keyFn, Function<? super T, ? extends V> valueFn) {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        for (T t : list) {
            K key = keyFn.apply(t);
            V value = valueFn.apply(t);
            multiMap.put(key, value);
        }
        return multiMap;
    }
}

