/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import cool.scx.constant.ScxDateTimeFormatter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

final class JacksonHelper {
    private static final NullKeySerializer DEFAULT_NULL_KEY_SERIALIZER = new NullKeySerializer();

    JacksonHelper() {
    }

    private static JavaTimeModule initJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(ScxDateTimeFormatter.yyyy_MM_dd_HH_mm_ss));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(ScxDateTimeFormatter.yyyy_MM_dd_HH_mm_ss));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(ScxDateTimeFormatter.yyyy_MM_dd));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(ScxDateTimeFormatter.yyyy_MM_dd));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(ScxDateTimeFormatter.HH_mm_ss));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(ScxDateTimeFormatter.HH_mm_ss));
        return javaTimeModule;
    }

    static <M extends ObjectMapper, B extends MapperBuilder<M, B>> M initObjectMapper(MapperBuilder<M, B> mapperBuilder) {
        ObjectMapper objectMapper = mapperBuilder.addModule((Module)JacksonHelper.initJavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).build();
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)DEFAULT_NULL_KEY_SERIALIZER);
        return (M)objectMapper;
    }

    static <M extends ObjectMapper> M setIgnoreJsonIgnore(M mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonIgnore());
        return mapper;
    }

    static <M extends ObjectMapper> M setIgnoreNullValue(M mapper) {
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private static class NullKeySerializer
    extends JsonSerializer<Object> {
        public static final String NULL_KEY = "";

        private NullKeySerializer() {
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                throw JsonMappingException.from((JsonGenerator)gen, (String)"NullKeySerializer is only for serializing null values.");
            }
            gen.writeFieldName(NULL_KEY);
        }
    }

    private static class IgnoreJsonIgnore
    extends JacksonAnnotationIntrospector {
        private IgnoreJsonIgnore() {
        }

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            return false;
        }
    }
}

