/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private static final char[] NUMBER_POOL = "0123456789".toCharArray();
    private static final char[] NUMBER_AND_LETTER_POOL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String randomString(int size, boolean withLetter) {
        StringBuilder code = new StringBuilder();
        char[] pool = withLetter ? NUMBER_AND_LETTER_POOL : NUMBER_POOL;
        for (int i = 0; i < size; ++i) {
            code.append(pool[RandomUtils.nextInt(pool.length)]);
        }
        return code.toString();
    }

    public static String randomString(int size) {
        return RandomUtils.randomString(size, true);
    }

    public static int randomNumber(int min, int max) {
        return RandomUtils.nextInt(min, max + 1);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    @SafeVarargs
    public static <T> T randomGet(T ... array) {
        int i = RandomUtils.nextInt(0, array.length);
        return array[i];
    }

    public static <T> T randomGet(List<T> list) {
        int i = RandomUtils.nextInt(0, list.size());
        return list.get(i);
    }

    public static <T> T[] randomGet(T[] array, int size) {
        if (size > array.length) {
            throw new IndexOutOfBoundsException("\u53d6\u51fa Array \u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e \u539f Array \u7684\u957f\u5ea6 !!!");
        }
        Object[] t = Arrays.copyOf(array, array.length);
        ArrayUtils.shuffle(t);
        return Arrays.copyOf(t, size);
    }

    public static <T> List<T> randomGet(List<T> list, int size) {
        if (size > list.size()) {
            throw new IndexOutOfBoundsException("\u53d6\u51fa List \u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e \u539f List \u7684\u957f\u5ea6 !!!");
        }
        ArrayList<T> r = new ArrayList<T>(list);
        Collections.shuffle(r);
        return r.subList(0, size);
    }

    public static int nextInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int nextInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }
}

