/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduler;

import cool.scx.scheduler.CounterRunnable;
import cool.scx.scheduler.FixedRunCountRunnable;
import cool.scx.scheduler.ScheduleStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public final class ScxScheduler
implements ScheduledExecutorService,
TaskScheduler {
    private final ScheduledExecutorService scheduledExecutorService;
    private final TaskScheduler taskScheduler;

    public ScxScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.taskScheduler = new ConcurrentTaskScheduler(this.scheduledExecutorService);
    }

    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.taskScheduler.schedule(task, trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        return this.taskScheduler.schedule(task, startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        return this.taskScheduler.scheduleAtFixedRate(task, startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        return this.taskScheduler.scheduleAtFixedRate(task, period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        return this.taskScheduler.scheduleWithFixedDelay(task, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        return this.taskScheduler.scheduleWithFixedDelay(task, delay);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(runnable, delay, unit);
    }

    public <R> ScheduledFuture<R> schedule(Callable<R> scxHandlerVR, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.schedule(scxHandlerVR, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduledExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.scheduledExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutorService.awaitTermination(timeout, unit);
    }

    public <R> Future<R> submit(Callable<R> task) {
        return this.scheduledExecutorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.scheduledExecutorService.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.scheduledExecutorService.submit(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.scheduledExecutorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.scheduledExecutorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.scheduledExecutorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.scheduledExecutorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.scheduledExecutorService.execute(command);
    }

    public ScheduledFuture<?> schedule(Consumer<ScheduleStatus> scxHandler, Trigger trigger) {
        return new CounterRunnable(scxHandler).schedule(this.taskScheduler, trigger);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Duration delay) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, long initialDelay, long period, TimeUnit unit) {
        return new CounterRunnable(scxHandler).scheduleAtFixedRate(this.scheduledExecutorService, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, long initialDelay, long delay, TimeUnit unit) {
        return new CounterRunnable(scxHandler).scheduleWithFixedDelay(this.scheduledExecutorService, initialDelay, delay, unit);
    }

    public ScheduledFuture<?> schedule(Consumer<ScheduleStatus> scxHandler, Trigger trigger, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).schedule(this.taskScheduler, trigger);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Instant startTime, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, Duration delay, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.taskScheduler, delay);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Consumer<ScheduleStatus> scxHandler, long initialDelay, long period, TimeUnit unit, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleAtFixedRate(this.scheduledExecutorService, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Consumer<ScheduleStatus> scxHandler, long initialDelay, long delay, TimeUnit unit, long maxRunCount) {
        return new FixedRunCountRunnable(scxHandler, maxRunCount).scheduleWithFixedDelay(this.scheduledExecutorService, initialDelay, delay, unit);
    }
}

