/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.cycle_iterable;

import cool.scx.util.cycle_iterable.CycleIterator;
import cool.scx.util.cycle_iterable.CycleReverseIterable;
import cool.scx.util.cycle_iterable.Node;
import java.lang.reflect.Array;
import java.util.Objects;

public class CycleIterable<T>
implements Iterable<T> {
    private Node<T> first;
    private Node<T> last;
    private int size;

    public Node<T> first() {
        return this.first;
    }

    public Node<T> last() {
        return this.last;
    }

    public int size() {
        return this.size;
    }

    private void link(Node<T> node) {
        node.prev = this.last;
        node.next = this.first;
        this.last.next = node;
        this.first.prev = node;
        this.last = node;
    }

    private T unlink(Node<T> node) {
        Node prev;
        Object item = node.item;
        Node next = node.next;
        next.prev = prev = node.prev;
        prev.next = next;
        if (node == this.first) {
            this.first = next;
        }
        if (node == this.last) {
            this.last = prev;
        }
        node.next = null;
        node.prev = null;
        node.item = null;
        return (T)item;
    }

    public boolean add(T item) {
        Node<T> node = new Node<T>(item);
        if (this.last == null) {
            node.next = node;
            node.prev = node.next;
            this.last = node.next;
            this.first = node.next;
        } else {
            this.link(node);
        }
        ++this.size;
        return true;
    }

    public boolean remove(Object o) {
        Node<T> node = this.node(o);
        if (node == null) {
            return false;
        }
        this.unlink(node);
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        }
        return true;
    }

    public void clear() {
        Node<Object> x = this.first;
        while (x != null) {
            Node next = x.next;
            x.item = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public Node<T> node(Object o) {
        if (this.first == null) {
            return null;
        }
        Node<Object> x = this.first;
        do {
            if (!Objects.equals(o, x.item)) continue;
            return x;
        } while ((x = x.next) != this.first);
        return null;
    }

    @Override
    public CycleIterator<T> iterator() {
        return new CycleIterator<T>(this.first);
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Node<Object> x = this.first;
        do {
            result[i] = x.item;
            ++i;
        } while ((x = x.next) != this.first);
        return result;
    }

    public <E> E[] toArray(E[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        E[] result = a;
        int i = 0;
        Node<Object> x = this.first;
        do {
            result[i] = x.item;
            ++i;
        } while ((x = x.next) != this.first);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        Node<T> node = this.node(o);
        return node != null;
    }

    public CycleReverseIterable<T> reverse() {
        return new CycleReverseIterable(this);
    }
}

