/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.io_stream_source;

import cool.scx.util.io_stream_source.InputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;

public class BytesSupplierSource
implements InputStreamSource {
    private final Supplier<byte[]> bytesSupplier;

    public BytesSupplierSource(Supplier<byte[]> bytesSupplier) {
        this.bytesSupplier = bytesSupplier;
    }

    @Override
    public InputStream toInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytesSupplier.get());
    }

    @Override
    public void writeToOutputStream(OutputStream out) throws IOException {
        out.write(this.bytesSupplier.get());
    }

    @Override
    public byte[] toBytes() throws IOException {
        return this.bytesSupplier.get();
    }

    @Override
    public void toFile(Path outputPath, OpenOption ... options) throws IOException {
        Files.write(outputPath, this.bytesSupplier.get(), options);
    }
}

