/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.core.ResolvableType;

public class MethodUtils {
    public static Method[] findAllMethods(Class<?> clazz) {
        ArrayList list = new ArrayList();
        while (clazz != null && clazz != Object.class) {
            Method[] methods = clazz.getDeclaredMethods();
            Collections.addAll(list, methods);
            clazz = clazz.getSuperclass();
        }
        return (Method[])list.toArray(Method[]::new);
    }

    public static Method[] findMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            if (m.getDeclaringClass() == Object.class) continue;
            list.add(m);
        }
        return (Method[])list.toArray(Method[]::new);
    }

    public static Annotation[] findAllAnnotations(Method sourceMethod) {
        Method[] methods;
        ArrayList list = new ArrayList();
        Class<?> sourceClass = sourceMethod.getDeclaringClass();
        for (Method m : methods = MethodUtils.findAllMethods(sourceClass)) {
            boolean isOverride = MethodUtils.isOverride(sourceMethod, m);
            if (!isOverride) continue;
            Collections.addAll(list, m.getDeclaredAnnotations());
        }
        return (Annotation[])list.toArray(Annotation[]::new);
    }

    private static boolean isOverride(Method rootMethod, Method candidateMethod) {
        return !Modifier.isPrivate(candidateMethod.getModifiers()) && candidateMethod.getName().equals(rootMethod.getName()) && MethodUtils.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean hasSameParameterTypes(Method rootMethod, Method candidateMethod) {
        if (candidateMethod.getParameterCount() != rootMethod.getParameterCount()) {
            return false;
        }
        Object[] rootParameterTypes = rootMethod.getParameterTypes();
        Object[] candidateParameterTypes = candidateMethod.getParameterTypes();
        if (Arrays.equals(candidateParameterTypes, rootParameterTypes)) {
            return true;
        }
        return MethodUtils.hasSameGenericTypeParameters(rootMethod, candidateMethod, rootParameterTypes);
    }

    private static boolean hasSameGenericTypeParameters(Method rootMethod, Method candidateMethod, Class<?>[] rootParameterTypes) {
        Class<?> sourceDeclaringClass = rootMethod.getDeclaringClass();
        Class<?> candidateDeclaringClass = candidateMethod.getDeclaringClass();
        if (!candidateDeclaringClass.isAssignableFrom(sourceDeclaringClass)) {
            return false;
        }
        for (int i = 0; i < rootParameterTypes.length; ++i) {
            Class resolvedParameterType = ResolvableType.forMethodParameter((Method)candidateMethod, (int)i, sourceDeclaringClass).resolve();
            if (rootParameterTypes[i] == resolvedParameterType) continue;
            return false;
        }
        return true;
    }
}

