/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import cool.scx.util.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ArrayUtils {
    public static int indexOf(byte[] a, byte[] a1) {
        for (int i = 0; i <= a.length - a1.length; ++i) {
            boolean found = true;
            for (int j = 0; j < a1.length; ++j) {
                if (a[i + j] == a1[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, Object[] a1) {
        for (int i = 0; i <= a.length - a1.length; ++i) {
            boolean found = true;
            for (int j = 0; j < a1.length; ++j) {
                if (Objects.equals(a[i + j], a1[j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static byte[] toPrimitive(Byte[] w) {
        byte[] p = new byte[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static long[] toPrimitive(Long[] w) {
        long[] p = new long[w.length];
        for (int i = 0; i < w.length; ++i) {
            p[i] = w[i];
        }
        return p;
    }

    public static long[] toPrimitive(List<Long> w) {
        long[] p = new long[w.size()];
        for (int i = 0; i < w.size(); ++i) {
            p[i] = w.get(i);
        }
        return p;
    }

    public static Byte[] toWrapper(byte[] p) {
        Byte[] w = new Byte[p.length];
        for (int i = 0; i < p.length; ++i) {
            w[i] = p[i];
        }
        return w;
    }

    public static long[] toLongArray(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        long[] longArray = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> List<List<T>> splitListN(List<T> list, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int rem = list.size() % n;
        int size = list.size() / n;
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            int curSize = size;
            if (rem > 0) {
                ++curSize;
                --rem;
            }
            result.add(list.subList(idx, idx + curSize));
            idx += curSize;
        }
        return result;
    }

    public static <T> List<List<T>> splitList(List<T> list, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += size) {
            int end = Math.min(i + size, list.size());
            result.add(list.subList(i, end));
        }
        return result;
    }

    public static void shuffle(Object[] arr) {
        int size;
        for (int i = size = arr.length; i > 1; --i) {
            ArrayUtils.swap(arr, i - 1, RandomUtils.nextInt(i));
        }
    }

    public static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }
}

