/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public final class MultiMap<K, V> {
    private final Map<K, List<V>> map;
    private final Supplier<List<V>> listSupplier;

    public MultiMap(Map<K, List<V>> map, Supplier<List<V>> listSupplier) {
        this.map = map;
        this.listSupplier = listSupplier;
    }

    public MultiMap(Supplier<List<V>> listSupplier) {
        this(new HashMap(), listSupplier);
    }

    public MultiMap(Map<K, List<V>> map) {
        this(map, ArrayList::new);
    }

    public MultiMap() {
        this(new HashMap(), ArrayList::new);
    }

    public Map<K, List<V>> toMultiValueMap() {
        return this.map;
    }

    public Map<K, V> toSingleValueMap() {
        LinkedHashMap<K, V> tempMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, List<V>> e : this.map.entrySet()) {
            K key = e.getKey();
            List<V> value = e.getValue();
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value.get(0));
        }
        return tempMap;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        List<V> list = this.listSupplier.get();
        for (List<V> vs : this.map.values()) {
            list.addAll(vs);
        }
        return list;
    }

    public List<V> get(K key) {
        return this.map.getOrDefault(key, this.listSupplier.get());
    }

    public V getFirst(K key) {
        List<V> values = this.map.get(key);
        return values == null || values.isEmpty() ? null : (V)values.get(0);
    }

    public boolean remove(K key, V value) {
        List<V> v = this.map.get(key);
        if (v != null && v.remove(value)) {
            if (v.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public List<V> removeAll(K key) {
        return this.map.remove(key);
    }

    public boolean put(K key, V value) {
        List v = this.map.computeIfAbsent(key, k -> this.listSupplier.get());
        return v.add(value);
    }

    public boolean putAll(K key, Collection<? extends V> values) {
        List v = this.map.computeIfAbsent(key, k -> this.listSupplier.get());
        return v.addAll(values);
    }

    public void putAll(Map<? extends K, ? extends V> v) {
        v.forEach(this::put);
    }

    public void putAll(MultiMap<? extends K, ? extends V> v) {
        for (Map.Entry<K, List<V>> entry : v.map.entrySet()) {
            K key = entry.getKey();
            List<V> values = entry.getValue();
            this.putAll(key, values);
        }
    }

    public void set(K key, V value) {
        List<V> values = this.listSupplier.get();
        values.add(value);
        this.map.put(key, values);
    }

    public void setAll(Map<? extends K, ? extends V> values) {
        values.forEach(this::set);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (List<V> values : this.map.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (List<V> value : this.map.values()) {
            value.clear();
        }
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public long size() {
        long size = 0L;
        for (List<V> value : this.map.values()) {
            size += (long)value.size();
        }
        return size;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> values = entry.getValue();
            for (V value : values) {
                action.accept(key, value);
            }
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

