/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import io.vertx.core.Future;
import java.util.function.Consumer;

public final class ScxFuture<T> {
    private final Future<T> vertxFuture;
    private Consumer<T> _onSuccess;
    private Consumer<Throwable> _onFailure;

    public ScxFuture(Future<T> vertxFuture) {
        this.vertxFuture = vertxFuture;
        this.vertxFuture.onSuccess(this::_onSuccess).onFailure(this::_onFailure);
    }

    public boolean isComplete() {
        return this.vertxFuture.isComplete();
    }

    public ScxFuture<T> onSuccess(Consumer<T> onSuccess) {
        this._onSuccess = onSuccess;
        return this;
    }

    public ScxFuture<T> onFailure(Consumer<Throwable> onFailure) {
        this._onFailure = onFailure;
        return this;
    }

    private void _onSuccess(T t) {
        if (this._onSuccess != null) {
            this._onSuccess.accept(t);
        }
    }

    private void _onFailure(Throwable throwable) {
        if (this._onFailure != null) {
            this._onFailure.accept(throwable);
        }
    }

    public Future<T> vertxFuture() {
        return this.vertxFuture;
    }
}

