package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.annotation.Annotation;

import static cool.scx.common.util.ObjectUtils.constructType;
import static cool.scx.common.util.reflect.InitHelper.*;

/**
 * ClassInfo
 */
public final class ClassInfo {

    private final Class<?> _class;
    private final JavaType type;
    private final boolean isRecord;
    private final boolean isInterface;
    private final ClassInfo superClass;
    private final Annotation[] annotations;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Annotation[] allAnnotations;
    private final FieldInfo[] allFields;
    private final MethodInfo[] allMethods;
    private final ConstructorInfo[] constructors;
    private final ConstructorInfo noArgsConstructor;
    private final ConstructorInfo recordConstructor;

    public ClassInfo(Class<?> _class) {
        this(constructType(_class));
    }

    ClassInfo(JavaType type) {
        this._class = type.getRawClass();
        this.type = type;
        this.isRecord = initIsRecord(this);
        this.isInterface = initIsInterface(this);
        this.superClass = initSuperClass(this);
        this.annotations = initAnnotations(this);
        this.fields = initFieldInfos(this);
        this.methods = initMethodInfos(this);
        this.allAnnotations = initAllAnnotations(this);
        this.allFields = initAllFieldInfos(this);
        this.allMethods = initAllMethodInfos(this);
        this.constructors = initConstructorInfos(this);
        this.noArgsConstructor = initNoArgsConstructor(this);
        this.recordConstructor = initRecordConstructor(this);
    }

    public Class<?> _class() {
        return this._class;
    }

    public JavaType type() {
        return type;
    }

    public boolean isRecord() {
        return isRecord;
    }

    public boolean isInterface() {
        return isInterface;
    }

    public ClassInfo superClass() {
        return superClass;
    }

    public Annotation[] annotations() {
        return annotations;
    }

    public FieldInfo[] fields() {
        return fields;
    }

    public MethodInfo[] methods() {
        return methods;
    }

    /**
     * 获取类所有的注解 包括继承自父类的注解
     *
     * @return 所有注解
     */
    public Annotation[] allAnnotations() {
        return allAnnotations;
    }

    /**
     * 获取类所有字段 包括继承自父类的字段
     *
     * @return 所有字段
     */
    public FieldInfo[] allFields() {
        return allFields;
    }

    /**
     * 获取类所有方法 包括继承自父类的方法
     *
     * @return 所有方法
     */
    public MethodInfo[] allMethods() {
        return allMethods;
    }

    public ConstructorInfo[] constructors() {
        return constructors;
    }

    /**
     * 无参构造函数
     */
    public ConstructorInfo noArgsConstructor() {
        return noArgsConstructor;
    }

    /**
     * Record 规范构造参数
     */
    public ConstructorInfo recordConstructor() {
        return recordConstructor;
    }

    public ClassInfo findSuperClassByType(Class<?> type) {
        return _class == type ? this : superClass != null ? superClass.findSuperClassByType(type) : null;
    }

}
