package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import static cool.scx.common.util.reflect.InitHelper.*;

/**
 * FieldInfo
 */
public final class FieldInfo {

    private final Field _field;
    private final ClassInfo classInfo;
    private final String name;
    private final JavaType type;
    private final AccessModifier accessModifier;
    private final Annotation[] annotations;

    FieldInfo(Field _field, ClassInfo classInfo) {
        this._field = _field;
        this.classInfo = classInfo;
        this.name = initName(this);
        this.type = initType(this);
        this.accessModifier = initAccessModifier(this);
        this.annotations = initAnnotations(this);
    }

    public Field _field() {
        return this._field;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    public String name() {
        return name;
    }

    public JavaType type() {
        return this.type;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._field.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this._field.getAnnotations();
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this._field.getAnnotationsByType(annotationClass);
    }

    public void setAccessible(boolean flag) {
        this._field.setAccessible(flag);
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        this._field.set(obj, value);
    }

    public Object get(Object obj) throws IllegalAccessException {
        return this._field.get(obj);
    }

}
