package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import static cool.scx.common.util.reflect.InitHelper.*;

/**
 * MethodInfo
 */
public final class MethodInfo implements ExecutableInfo {

    private final Method _method;
    private final ClassInfo classInfo;
    private final String name;
    private final Annotation[] annotations;
    private final JavaType returnType;
    private final AccessModifier accessModifier;
    private final ParameterInfo[] parameters;
    private final MethodInfo superMethod;
    private final Annotation[] allAnnotations;

    MethodInfo(Method _method, ClassInfo classInfo) {
        this._method = _method;
        this.classInfo = classInfo;
        this.name = initName(this);
        this.annotations = initAnnotations(this);
        this.returnType = initReturnType(this);
        this.accessModifier = initAccessModifier(this);
        this.parameters = initParameterInfos(this);
        this.superMethod = initSuperMethod(this);
        this.allAnnotations = initAllAnnotations(this);
    }

    public Method _method() {
        return _method;
    }

    @Override
    public ClassInfo classInfo() {
        return classInfo;
    }

    public String name() {
        return name;
    }

    public Annotation[] annotations() {
        return annotations;
    }

    public JavaType returnType() {
        return returnType;
    }

    public AccessModifier accessModifier() {
        return accessModifier;
    }

    @Override
    public ParameterInfo[] parameters() {
        return parameters;
    }

    public MethodInfo superMethod() {
        return superMethod;
    }

    /**
     * 获取当前方法的注解 以及 重写的父类方法的注解
     */
    public Annotation[] allAnnotations() {
        return allAnnotations;
    }

    public void setAccessible(boolean flag) {
        this._method.setAccessible(flag);
    }

}
