/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.http_client;

import cool.scx.common.http_client.ScxHttpClient;
import cool.scx.common.http_client.ScxHttpClientRequest;
import cool.scx.common.http_client.ScxHttpClientRequestBody;
import cool.scx.common.http_client.ScxHttpClientResponse;
import cool.scx.common.standard.HttpMethod;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

public final class ScxHttpClientHelper {
    private static final ScxHttpClient defaultClient = new ScxHttpClient();

    public static ScxHttpClientResponse request(ScxHttpClientRequest request) throws IOException, InterruptedException {
        return defaultClient.request(request);
    }

    public static CompletableFuture<ScxHttpClientResponse> requestAsync(ScxHttpClientRequest request) {
        return defaultClient.requestAsync(request);
    }

    public static ScxHttpClientResponse get(String uri) throws IOException, InterruptedException {
        return ScxHttpClientHelper.request(new ScxHttpClientRequest().method(HttpMethod.GET).uri(URI.create(uri)));
    }

    public static CompletableFuture<ScxHttpClientResponse> getAsync(String uri) {
        return ScxHttpClientHelper.requestAsync(new ScxHttpClientRequest().method(HttpMethod.GET).uri(URI.create(uri)));
    }

    public static ScxHttpClientResponse post(String uri, ScxHttpClientRequestBody body) throws IOException, InterruptedException {
        return ScxHttpClientHelper.request(new ScxHttpClientRequest().method(HttpMethod.POST).body(body).uri(URI.create(uri)));
    }

    public static CompletableFuture<ScxHttpClientResponse> postAsync(String uri, ScxHttpClientRequestBody body) {
        return ScxHttpClientHelper.requestAsync(new ScxHttpClientRequest().method(HttpMethod.POST).body(body).uri(URI.create(uri)));
    }

    public static ScxHttpClientResponse put(String uri, ScxHttpClientRequestBody body) throws IOException, InterruptedException {
        return ScxHttpClientHelper.request(new ScxHttpClientRequest().method(HttpMethod.PUT).body(body).uri(URI.create(uri)));
    }

    public static CompletableFuture<ScxHttpClientResponse> putAsync(String uri, ScxHttpClientRequestBody body) {
        return ScxHttpClientHelper.requestAsync(new ScxHttpClientRequest().method(HttpMethod.PUT).body(body).uri(URI.create(uri)));
    }

    public static ScxHttpClientResponse delete(String uri, ScxHttpClientRequestBody body) throws IOException, InterruptedException {
        return ScxHttpClientHelper.request(new ScxHttpClientRequest().method(HttpMethod.DELETE).body(body).uri(URI.create(uri)));
    }

    public static CompletableFuture<ScxHttpClientResponse> deleteAsync(String uri, ScxHttpClientRequestBody body) {
        return ScxHttpClientHelper.requestAsync(new ScxHttpClientRequest().method(HttpMethod.DELETE).body(body).uri(URI.create(uri)));
    }
}

