/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cool.scx.common.util.JacksonHelper;
import cool.scx.common.util.StringUtils;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ObjectUtils {
    public static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final JsonMapper JSON_MAPPER = (JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder());
    private static final XmlMapper XML_MAPPER = (XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder());
    private static final JsonMapper JSON_MAPPER_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder()));
    private static final XmlMapper XML_MAPPER_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder()));
    private static final JsonMapper JSON_MAPPER_IGNORE_NULL_VALUE = JacksonHelper.setIgnoreNullValue((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder()));
    private static final XmlMapper XML_MAPPER_IGNORE_NULL_VALUE = JacksonHelper.setIgnoreNullValue((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder()));
    private static final JsonMapper JSON_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.setIgnoreNullValue((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder())));
    private static final XmlMapper XML_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.setIgnoreNullValue((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder())));

    public static JsonMapper jsonMapper(Option ... options) {
        Option.Info info = new Option.Info(options);
        if (info.ignoreJsonIgnore && !info.ignoreNullValue) {
            return JSON_MAPPER_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreJsonIgnore) {
            return JSON_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreNullValue) {
            return JSON_MAPPER_IGNORE_NULL_VALUE;
        }
        return JSON_MAPPER;
    }

    public static XmlMapper xmlMapper(Option ... options) {
        Option.Info info = new Option.Info(options);
        if (info.ignoreJsonIgnore && !info.ignoreNullValue) {
            return XML_MAPPER_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreJsonIgnore) {
            return XML_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreNullValue) {
            return XML_MAPPER_IGNORE_NULL_VALUE;
        }
        return XML_MAPPER;
    }

    public static JavaType constructType(Type type) {
        return ObjectUtils.getTypeFactory().constructType(type);
    }

    public static JavaType constructType(TypeReference<?> typeRef) {
        return ObjectUtils.getTypeFactory().constructType(typeRef);
    }

    public static JavaType resolveMemberType(Type type, TypeBindings contextBindings) {
        return ObjectUtils.getTypeFactory().resolveMemberType(type, contextBindings);
    }

    public static TypeFactory getTypeFactory() {
        return JSON_MAPPER.getTypeFactory();
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, javaType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> tClass, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(tClass));
    }

    public static <T> T convertValue(Object fromValue, Type toValueType, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueType));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueTypeRef));
    }

    public static String toJson(Object value, String defaultValue, Option ... options) {
        try {
            return ObjectUtils.toJson(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toXml(Object value, String defaultValue, Option ... options) {
        try {
            return ObjectUtils.toXml(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toJson(Object value, Option ... options) throws JsonProcessingException {
        return ObjectUtils.jsonMapper(options).writeValueAsString(value);
    }

    public static String toXml(Object value, Option ... options) throws JsonProcessingException {
        return ObjectUtils.xmlMapper(options).writeValueAsString(value);
    }

    private static Map<String, Object> flatMap0(Map<?, ?> sourceMap, String parentKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object prefix = StringUtils.isBlank(parentKey) ? "" : parentKey + ".";
        sourceMap.forEach((arg_0, arg_1) -> ObjectUtils.lambda$flatMap0$0((String)prefix, result, arg_0, arg_1));
        return result;
    }

    public static Map<String, Object> flatMap(Map<?, ?> sourceMap) {
        return ObjectUtils.flatMap0(sourceMap, null);
    }

    private static /* synthetic */ void lambda$flatMap0$0(String prefix, LinkedHashMap result, Object key, Object value) {
        String newKey = prefix + String.valueOf(key);
        if (value instanceof Map) {
            Map m = (Map)value;
            result.putAll(ObjectUtils.flatMap0(m, newKey));
        } else {
            result.put(newKey, value);
        }
    }

    public static enum Option {
        IGNORE_NULL_VALUE,
        IGNORE_JSON_IGNORE;


        private static class Info {
            boolean ignoreNullValue = false;
            boolean ignoreJsonIgnore = false;

            Info(Option ... options) {
                block4: for (Option option : options) {
                    switch (option.ordinal()) {
                        case 0: {
                            this.ignoreNullValue = true;
                            continue block4;
                        }
                        case 1: {
                            this.ignoreJsonIgnore = true;
                        }
                    }
                }
            }
        }
    }
}

