/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.ansi;

import com.sun.jna.Function;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import cool.scx.common.standard.OSType;
import cool.scx.common.util.OSHelper;
import cool.scx.common.util.ansi.AnsiColor;
import cool.scx.common.util.circular_iterable.CircularIterable;
import java.util.Iterator;

class AnsiHelper {
    AnsiHelper() {
    }

    static void enableWindows10AnsiSupport() {
        Function GetStdHandleFunc = Function.getFunction((String)"kernel32", (String)"GetStdHandle");
        WinDef.DWORD STD_OUTPUT_HANDLE = new WinDef.DWORD(-11L);
        WinNT.HANDLE hOut = (WinNT.HANDLE)GetStdHandleFunc.invoke(WinNT.HANDLE.class, new Object[]{STD_OUTPUT_HANDLE});
        WinDef.DWORDByReference p_dwMode = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Function GetConsoleModeFunc = Function.getFunction((String)"kernel32", (String)"GetConsoleMode");
        GetConsoleModeFunc.invoke(WinDef.BOOL.class, new Object[]{hOut, p_dwMode});
        int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
        WinDef.DWORD dwMode = p_dwMode.getValue();
        dwMode.setValue((long)(dwMode.intValue() | ENABLE_VIRTUAL_TERMINAL_PROCESSING));
        Function SetConsoleModeFunc = Function.getFunction((String)"kernel32", (String)"SetConsoleMode");
        SetConsoleModeFunc.invoke(WinDef.BOOL.class, new Object[]{hOut, dwMode});
    }

    static boolean detectIfAnsiCapable() {
        OSHelper.OSInfo osInfo = OSHelper.getOSInfo();
        if (osInfo.type() == OSType.WINDOWS) {
            if (osInfo.version().startsWith("10") || osInfo.version().startsWith("11")) {
                try {
                    AnsiHelper.enableWindows10AnsiSupport();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public static Iterator<AnsiColor> initCycleColor() {
        CircularIterable<AnsiColor> cycleIterator = new CircularIterable<AnsiColor>();
        for (AnsiColor allColor : AnsiColor.values()) {
            cycleIterator.add(allColor);
        }
        return cycleIterator.iterator();
    }
}

