/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.image;

import cool.scx.common.util.io_stream_source.InputStreamSource;
import cool.scx.common.util.io_stream_source.OutputStreamSource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class ProgressiveJPEGBuilder
implements OutputStreamSource {
    private final BufferedImage sourceImage;

    public ProgressiveJPEGBuilder(InputStreamSource source) throws IOException {
        this.sourceImage = ImageIO.read(source.toInputStream());
    }

    public ProgressiveJPEGBuilder(Path path) throws IOException {
        this(InputStreamSource.of(path));
    }

    public ProgressiveJPEGBuilder(byte[] bytes) throws IOException {
        this(InputStreamSource.of(bytes));
    }

    public ProgressiveJPEGBuilder(Supplier<byte[]> bytesSupplier) throws IOException {
        this(InputStreamSource.of(bytesSupplier));
    }

    public ProgressiveJPEGBuilder(InputStream inputStream) throws IOException {
        this(InputStreamSource.of(inputStream));
    }

    public static ImageWriter getImageWriter(String formatName) {
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByFormatName(formatName.trim().toLowerCase());
        ImageWriter writer = writerIterator.next();
        if (writer == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u683c\u5f0f\u7684 ImageWriter , formatName : " + formatName);
        }
        return writer;
    }

    @Override
    public void writeToOutputStream(OutputStream out) throws IOException {
        ImageWriter jpegWriter = ProgressiveJPEGBuilder.getImageWriter("jpeg");
        ImageWriteParam writeParam = jpegWriter.getDefaultWriteParam();
        writeParam.setProgressiveMode(1);
        try (MemoryCacheImageOutputStream m = new MemoryCacheImageOutputStream(out);){
            jpegWriter.setOutput(m);
            jpegWriter.write(null, new IIOImage(this.sourceImage, null, null), writeParam);
            jpegWriter.dispose();
        }
    }
}

