/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.reflect.ConstructorInfo;
import cool.scx.common.util.reflect.FieldInfo;
import cool.scx.common.util.reflect.InitHelper;
import cool.scx.common.util.reflect.MethodInfo;
import java.lang.annotation.Annotation;

public final class ClassInfo {
    private final Class<?> _class;
    private final JavaType type;
    private final boolean isRecord;
    private final boolean isInterface;
    private final ClassInfo superClass;
    private final Annotation[] annotations;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Annotation[] allAnnotations;
    private final FieldInfo[] allFields;
    private final MethodInfo[] allMethods;
    private final ConstructorInfo[] constructors;
    private final ConstructorInfo noArgsConstructor;
    private final ConstructorInfo recordConstructor;

    public ClassInfo(Class<?> _class) {
        this(ObjectUtils.constructType(_class));
    }

    ClassInfo(JavaType type) {
        this._class = type.getRawClass();
        this.type = type;
        this.isRecord = InitHelper.initIsRecord(this);
        this.isInterface = InitHelper.initIsInterface(this);
        this.superClass = InitHelper.initSuperClass(this);
        this.annotations = InitHelper.initAnnotations(this);
        this.fields = InitHelper.initFieldInfos(this);
        this.methods = InitHelper.initMethodInfos(this);
        this.allAnnotations = InitHelper.initAllAnnotations(this);
        this.allFields = InitHelper.initAllFieldInfos(this);
        this.allMethods = InitHelper.initAllMethodInfos(this);
        this.constructors = InitHelper.initConstructorInfos(this);
        this.noArgsConstructor = InitHelper.initNoArgsConstructor(this);
        this.recordConstructor = InitHelper.initRecordConstructor(this);
    }

    public Class<?> _class() {
        return this._class;
    }

    public JavaType type() {
        return this.type;
    }

    public boolean isRecord() {
        return this.isRecord;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public ClassInfo superClass() {
        return this.superClass;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public FieldInfo[] fields() {
        return this.fields;
    }

    public MethodInfo[] methods() {
        return this.methods;
    }

    public Annotation[] allAnnotations() {
        return this.allAnnotations;
    }

    public FieldInfo[] allFields() {
        return this.allFields;
    }

    public MethodInfo[] allMethods() {
        return this.allMethods;
    }

    public ConstructorInfo[] constructors() {
        return this.constructors;
    }

    public ConstructorInfo noArgsConstructor() {
        return this.noArgsConstructor;
    }

    public ConstructorInfo recordConstructor() {
        return this.recordConstructor;
    }

    public ClassInfo findSuperClassByType(Class<?> type) {
        return this._class == type ? this : (this.superClass != null ? this.superClass.findSuperClassByType(type) : null);
    }
}

