/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.reflect.AccessModifier;
import cool.scx.common.util.reflect.ClassInfo;
import cool.scx.common.util.reflect.ConstructorInfo;
import cool.scx.common.util.reflect.FieldInfo;
import cool.scx.common.util.reflect.MethodInfo;
import cool.scx.common.util.reflect.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;

final class InitHelper {
    InitHelper() {
    }

    public static boolean initIsRecord(ClassInfo classInfo) {
        return classInfo._class().isRecord();
    }

    public static boolean initIsInterface(ClassInfo classInfo) {
        return classInfo._class().isInterface();
    }

    public static ClassInfo initSuperClass(ClassInfo classInfo) {
        return classInfo.type().getSuperClass() != null ? new ClassInfo(classInfo.type().getSuperClass()) : null;
    }

    public static String initName(FieldInfo fieldInfo) {
        return fieldInfo._field().getName();
    }

    public static String initName(MethodInfo methodInfo) {
        return methodInfo._method().getName();
    }

    public static String initName(ParameterInfo parameterInfo) {
        return parameterInfo._parameter().getName();
    }

    public static AccessModifier initAccessModifier(FieldInfo fieldInfo) {
        return InitHelper.initAccessModifier(fieldInfo._field().getModifiers());
    }

    public static AccessModifier initAccessModifier(MethodInfo methodInfo) {
        return InitHelper.initAccessModifier(methodInfo._method().getModifiers());
    }

    public static AccessModifier initAccessModifier(ConstructorInfo constructorInfo) {
        return InitHelper.initAccessModifier(constructorInfo._constructor().getModifiers());
    }

    public static AccessModifier initAccessModifier(int m) {
        if (Modifier.isPublic(m)) {
            return AccessModifier.PUBLIC;
        }
        if (Modifier.isProtected(m)) {
            return AccessModifier.PROTECTED;
        }
        if (Modifier.isPrivate(m)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.DEFAULT;
    }

    public static JavaType initType(FieldInfo fieldInfo) {
        return InitHelper.initType(fieldInfo._field().getGenericType(), fieldInfo.classInfo());
    }

    public static JavaType initType(ParameterInfo parameterInfo) {
        return InitHelper.initType(parameterInfo._parameter().getParameterizedType(), parameterInfo.executableInfo().classInfo());
    }

    public static JavaType initReturnType(MethodInfo methodInfo) {
        return InitHelper.initType(methodInfo._method().getGenericReturnType(), methodInfo.classInfo());
    }

    public static JavaType initType(Type type, ClassInfo classInfo) {
        return ObjectUtils.resolveMemberType(type, classInfo.type().getBindings());
    }

    public static Annotation[] initAnnotations(ClassInfo classInfo) {
        return classInfo._class().getDeclaredAnnotations();
    }

    public static Annotation[] initAnnotations(FieldInfo fieldInfo) {
        return fieldInfo._field().getDeclaredAnnotations();
    }

    public static Annotation[] initAnnotations(MethodInfo methodInfo) {
        return methodInfo._method().getDeclaredAnnotations();
    }

    public static Annotation[] initAllAnnotations(MethodInfo methodInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (methodInfo != null) {
            Collections.addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    public static Annotation[] initAllAnnotations(ClassInfo classInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    public static ConstructorInfo[] initConstructorInfos(ClassInfo classInfo) {
        return (ConstructorInfo[])Stream.of(classInfo._class().getDeclaredConstructors()).map(c -> new ConstructorInfo((Constructor<?>)c, classInfo)).toArray(ConstructorInfo[]::new);
    }

    public static ConstructorInfo initNoArgsConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    public static ConstructorInfo initRecordConstructor(ClassInfo classInfo) {
        if (!classInfo.isRecord()) {
            return null;
        }
        JavaType[] recordComponentTypes = InitHelper.getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = InitHelper.hasSameParameterTypes(constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    public static FieldInfo[] initFieldInfos(ClassInfo classInfo) {
        return (FieldInfo[])Arrays.stream(classInfo._class().getDeclaredFields()).map(field -> new FieldInfo((Field)field, classInfo)).toArray(FieldInfo[]::new);
    }

    public static FieldInfo[] initAllFieldInfos(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static MethodInfo[] initMethodInfos(ClassInfo classInfo) {
        return (MethodInfo[])Arrays.stream(classInfo._class().getDeclaredMethods()).filter(method -> !method.isBridge()).map(method -> new MethodInfo((Method)method, classInfo)).toArray(MethodInfo[]::new);
    }

    public static MethodInfo initSuperMethod(MethodInfo methodInfo) {
        for (ClassInfo superClass = methodInfo.classInfo().superClass(); superClass != null; superClass = superClass.superClass()) {
            MethodInfo[] superMethods;
            for (MethodInfo superMethod : superMethods = superClass.methods()) {
                boolean b = InitHelper.isOverride(methodInfo, superMethod);
                if (!b) continue;
                return superMethod;
            }
        }
        return null;
    }

    public static MethodInfo[] initAllMethodInfos(ClassInfo classInfo) {
        HashSet<MethodInfo> filter = new HashSet<MethodInfo>();
        ArrayList<MethodInfo> allMethodInfo = new ArrayList<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methods;
            for (MethodInfo method : methods = classInfo.methods()) {
                boolean b;
                if (method.superMethod() != null) {
                    filter.add(method.superMethod());
                }
                if (b = filter.contains(method)) continue;
                allMethodInfo.add(method);
            }
            classInfo = classInfo.superClass();
        }
        return (MethodInfo[])allMethodInfo.toArray(MethodInfo[]::new);
    }

    public static ParameterInfo[] initParameterInfos(MethodInfo methodInfo) {
        return (ParameterInfo[])Arrays.stream(methodInfo._method().getParameters()).map(parameter -> new ParameterInfo((Parameter)parameter, methodInfo)).toArray(ParameterInfo[]::new);
    }

    public static ParameterInfo[] initParameterInfos(ConstructorInfo constructorInfo) {
        return (ParameterInfo[])Arrays.stream(constructorInfo._constructor().getParameters()).map(parameter -> new ParameterInfo((Parameter)parameter, constructorInfo)).toArray(ParameterInfo[]::new);
    }

    private static boolean isOverride(MethodInfo rootMethod, MethodInfo candidateMethod) {
        return AccessModifier.PRIVATE != candidateMethod.accessModifier() && candidateMethod.name().equals(rootMethod.name()) && InitHelper.hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static JavaType[] getRecordComponentsTypes(ClassInfo classInfo) {
        return (JavaType[])Arrays.stream(classInfo._class().getRecordComponents()).map(r -> InitHelper.initType(r.getGenericType(), classInfo)).toArray(JavaType[]::new);
    }

    private static boolean hasSameParameterTypes(MethodInfo rootMethod, MethodInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = p2[i].type().getRawClass())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSameParameterTypes(ConstructorInfo constructorInfo, JavaType[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = types[i].getRawClass())) continue;
            return false;
        }
        return true;
    }
}

