package cool.scx.common.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import static cool.scx.common.reflect.InitHelper.initAccessModifier;
import static cool.scx.common.reflect.InitHelper.initParameterInfos;

/**
 * ConstructorInfo
 */
public final class ConstructorInfo implements ExecutableInfo {

    private final Constructor<?> _constructor;
    private final ClassInfo classInfo;
    private final ParameterInfo[] parameters;
    private final AccessModifier accessModifier;

    ConstructorInfo(Constructor<?> _constructor, ClassInfo classInfo) {
        this._constructor = _constructor;
        this.classInfo = classInfo;
        this.parameters = initParameterInfos(this);
        this.accessModifier = initAccessModifier(this);
    }

    public Constructor<?> _constructor() {
        return _constructor;
    }

    @Override
    public ClassInfo classInfo() {
        return classInfo;
    }

    @Override
    public ParameterInfo[] parameters() {
        return parameters;
    }

    public AccessModifier accessModifier() {
        return accessModifier;
    }

    public void setAccessible(boolean flag) {
        _constructor.setAccessible(flag);
    }

    @SuppressWarnings("unchecked")
    public <T> T newInstance(Object... args) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return (T) _constructor.newInstance(args);
    }

}
