package cool.scx.common.reflect;

import com.fasterxml.jackson.databind.JavaType;

import java.lang.reflect.Parameter;

import static cool.scx.common.reflect.InitHelper.initName;
import static cool.scx.common.reflect.InitHelper.initType;

/**
 * ParameterInfo
 */
public final class ParameterInfo {

    private final Parameter _parameter;
    private final ExecutableInfo executableInfo;
    private final String name;
    private final JavaType type;

    ParameterInfo(Parameter _parameter, ExecutableInfo executableInfo) {
        this._parameter = _parameter;
        this.executableInfo = executableInfo;
        this.name = initName(this);
        this.type = initType(this);
    }

    public Parameter _parameter() {
        return _parameter;
    }

    public ExecutableInfo executableInfo() {
        return executableInfo;
    }

    public String name() {
        return name;
    }

    public JavaType type() {
        return type;
    }

}
