/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class LockByKey<T> {
    private final ConcurrentHashMap<T, LockWrapper> lockMap = new ConcurrentHashMap();
    private final Function<T, Semaphore> semaphoreBuilder;

    public LockByKey() {
        this(k -> new Semaphore(1, true));
    }

    public LockByKey(Function<T, Semaphore> semaphoreBuilder) {
        this.semaphoreBuilder = semaphoreBuilder;
    }

    public void lock(T key) {
        LockWrapper l = this.lockMap.computeIfAbsent(key, k -> new LockWrapper(this.semaphoreBuilder.apply(k)));
        l.queueLength.incrementAndGet();
        l.lock.acquireUninterruptibly();
    }

    public void unlock(T key) {
        LockWrapper l = this.lockMap.get(key);
        if (l != null) {
            l.lock.release();
            if (l.queueLength.decrementAndGet() == 0) {
                this.lockMap.remove(key, l);
            }
        }
    }

    private static class LockWrapper {
        private final Semaphore lock;
        private final AtomicInteger queueLength;

        private LockWrapper(Semaphore lock) {
            this.lock = lock;
            this.queueLength = new AtomicInteger(0);
        }
    }
}

