/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.scheduler;

import cool.scx.scheduler.ScheduleStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

class CounterRunnable
implements Runnable {
    final AtomicLong runCount = new AtomicLong(1L);
    final Consumer<ScheduleStatus> scxHandler;
    ScheduledFuture<?> scheduledFuture = null;

    public CounterRunnable(Consumer<ScheduleStatus> scxHandler) {
        this.scxHandler = scxHandler;
    }

    @Override
    public void run() {
        this.scxHandler.accept(new ScheduleStatus(this.runCount.getAndIncrement(), this.scheduledFuture));
    }

    public ScheduledFuture<?> schedule(TaskScheduler executor, Trigger trigger) {
        this.scheduledFuture = executor.schedule((Runnable)this, trigger);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(TaskScheduler executor, Instant startTime, Duration delay) {
        this.scheduledFuture = executor.scheduleAtFixedRate((Runnable)this, startTime, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(TaskScheduler executor, Duration delay) {
        this.scheduledFuture = executor.scheduleAtFixedRate((Runnable)this, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(TaskScheduler executor, Instant startTime, Duration delay) {
        this.scheduledFuture = executor.scheduleWithFixedDelay((Runnable)this, startTime, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(TaskScheduler executor, Duration delay) {
        this.scheduledFuture = executor.scheduleWithFixedDelay((Runnable)this, delay);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(ScheduledExecutorService taskScheduler, long initialDelay, long period, TimeUnit unit) {
        this.scheduledFuture = taskScheduler.scheduleAtFixedRate(this, initialDelay, period, unit);
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(ScheduledExecutorService taskScheduler, long initialDelay, long delay, TimeUnit unit) {
        this.scheduledFuture = taskScheduler.scheduleWithFixedDelay(this, initialDelay, delay, unit);
        return this.scheduledFuture;
    }
}

