/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

public final class OSHelper {
    private static final OSInfo osInfo = OSHelper.initOSInfo();

    private static OSInfo initOSInfo() {
        OSType osType = OSHelper.getOSType();
        String osVersion = System.getProperty("os.version");
        return new OSInfo(osType, osVersion);
    }

    private static OSType getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
                return OSType.ANDROID;
            }
            return OSType.LINUX;
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OSType.MAC;
        }
        if (osName.startsWith("Windows")) {
            return OSType.WINDOWS;
        }
        return OSType.UNKNOWN;
    }

    public static OSInfo getOSInfo() {
        return osInfo;
    }

    public static boolean isMac() {
        return OSHelper.osInfo.type == OSType.MAC;
    }

    public static boolean isAndroid() {
        return OSHelper.osInfo.type == OSType.ANDROID;
    }

    public static boolean isLinux() {
        return OSHelper.osInfo.type == OSType.LINUX;
    }

    public static boolean isWindows() {
        return OSHelper.osInfo.type == OSType.WINDOWS;
    }

    public static enum OSType {
        MAC,
        LINUX,
        WINDOWS,
        ANDROID,
        UNKNOWN;

    }

    public record OSInfo(OSType type, String version) {
    }
}

