/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.common.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.HexFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtils {
    private static final Pattern DISPLAY_SIZE_PATTERN = Pattern.compile("^([\\d.]+) *([a-zA-Z]{0,2})$");

    public static String longToDisplaySize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static long displaySizeToLong(String str) {
        String units;
        Matcher matcher = DISPLAY_SIZE_PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(str + " : \u65e0\u6cd5\u8f6c\u6362\u4e3a long !!!");
        }
        double amount = Double.parseDouble(matcher.group(1));
        long s = switch (units = matcher.group(2)) {
            case "", "B" -> 1L;
            case "KB" -> 1024L;
            case "MB" -> 0x100000L;
            case "GB" -> 0x40000000L;
            case "TB" -> 0x10000000000L;
            default -> throw new IllegalArgumentException(units + " : \u672a\u77e5\u7684\u6570\u636e\u5355\u4f4d !!!");
        };
        return (long)(amount * (double)s);
    }

    public static void delete(final Path start, DeleteOption ... options) throws IOException {
        final DeleteOption.Info info = new DeleteOption.Info(options);
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                boolean dontNeedDelete;
                boolean bl = dontNeedDelete = info.excludeRoot() && Files.isSameFile(start, dir);
                if (!dontNeedDelete) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(start, (FileVisitor<? super Path>)visitor);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static void move(Path source, Path target, CopyOption ... options) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.move(source, target, options);
    }

    public static void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.copy(source, target, options);
    }

    public static void write(Path path, byte[] bytes, OpenOption ... options) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, bytes, options);
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    public static String getExtension(String path) {
        String fileName = FileUtils.getFileName(path);
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String getFileNameWithoutExtension(String path) {
        String fileName = FileUtils.getFileName(path);
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    public static String getHead(String filePath, int length) throws IOException {
        try (RandomAccessFile accessFile = new RandomAccessFile(filePath, "r");){
            byte[] headBytes = new byte[length];
            accessFile.read(headBytes);
            String string = HexFormat.of().formatHex(headBytes);
            return string;
        }
    }

    public static enum DeleteOption {
        EXCLUDE_ROOT;


        static class Info {
            boolean excludeRoot;

            Info(DeleteOption ... options) {
                for (DeleteOption option : options) {
                    switch (option.ordinal()) {
                        case 0: {
                            this.excludeRoot = true;
                        }
                    }
                }
            }

            boolean excludeRoot() {
                return this.excludeRoot;
            }
        }
    }
}

